function value = value_fixed_leg_CDS(date_nums, T, coupon, LGD, discounts, discounts_inbetween, default_probs, liq_prem)
% --------------------------------------------------------------------------------------------------
% For each date, calculate the market value of the payments made by the buyer of protection.
% --------------------------------------------------------------------------------------------------
% date_nums             ... datenums for which to calculate model-implied price
% T                     ... time to maturity of index
% coupon                ... coupon rates for individual tranches
% LGD                   ... loss given default
% discounts             ... discount curve (quarterly frequency, end of period)
% discounts_inbetween   ... discount curve (quarterly frequency, middle of period)
% default_probs         ... matrix where entry (i,j) gives the probability for the i-th date, for
%                           the j-th time horizon.
% liq_prem              ... liquidity premium of CDS vs. index, i.e. excess discount rate
% --------------------------------------------------------------------------------------------------
% sample call: value_fixed_leg_CDS(cds_test.dates{1}, 5, cds_test.market_price{1}, ...)
% --------------------------------------------------------------------------------------------------

% Cut default & survival probabilities down to relevant dates & horizons
[trash, used_dates] = is_member_sorted_c(date_nums, default_probs.dates);
missing = find(used_dates==0);
% If data not available, use most recently available data
for i=1:length(missing)
    pos = missing(i) - 1;
    found = false;
    while ((~found) && (pos > 0))
       if (~is_member_sorted_c(pos, missing))
           used_dates(missing(i)) = used_dates(pos);
           found = true;
       end
       pos = pos - 1;
    end
end

% Calculate market value of coupon payments (including accruals in case of default
value = zeros(length(coupon), 1);
for i=1:length(value)
    % Calculate discounts factors including liquidity premium
    T_max = ceil(T(i)*4);
    horizons = (T(i) - (T_max-1)/4):0.25:T(i);
    %horizons_inbetween = max(0, (horizons - 1/8));
    disc_t = discounts(i,1:T_max) .* exp(-horizons * liq_prem(i));
    %disc_t_inbetween = discounts_inbetween(i,1:T_max) .* exp(-horizons_inbetween * liq_prem(i));
    
    % Calculate value of fixed leg
    surv_probs_t = default_probs.surv_probs(used_dates(i), 1:T_max);
    %default_probs_t = default_probs.default_probs(used_dates(i), 1:T_max);
    %value(i) = coupon(i)/1e4/4 * sum(surv_probs_t .* disc_t + default_probs_t .* disc_t_inbetween/2);
    value(i) = coupon(i)/1e4 * (sum(surv_probs_t .* disc_t)/4*(365/360) - (1/4 * (365/360) - horizons(1)));   % last term: accrued premium
end




